/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.teleportation;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.dimlib.api.DimensionAPI;
import qouteall.imm_ptl.core.IPMcHelper;
import qouteall.imm_ptl.core.IPPerServerInfo;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.ScaleUtils;
import qouteall.imm_ptl.core.chunk_loading.ImmPtlChunkTracking;
import qouteall.imm_ptl.core.collision.PortalCollisionHandler;
import qouteall.imm_ptl.core.compat.GravityChangerInterface;
import qouteall.imm_ptl.core.ducks.IEEntity;
import qouteall.imm_ptl.core.ducks.IEServerPlayNetworkHandler;
import qouteall.imm_ptl.core.ducks.IEServerPlayerEntity;
import qouteall.imm_ptl.core.mc_utils.ServerTaskList;
import qouteall.imm_ptl.core.platform_specific.IPConfig;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.global_portals.GlobalPortalStorage;
import qouteall.imm_ptl.core.teleportation.TeleportationUtil;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.McRemoteProcedureCall;
import qouteall.q_misc_util.my_util.MyTaskList;
import qouteall.q_misc_util.my_util.WithDim;

public class ServerTeleportationManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Set<class_1297> teleportingEntities = new HashSet<class_1297>();
    private final WeakHashMap<class_1297, Long> lastTeleportGameTime = new WeakHashMap();
    public boolean isFiringMyChangeDimensionEvent = false;
    public final WeakHashMap<class_3222, WithDim<class_243>> lastPosition = new WeakHashMap();

    public static ServerTeleportationManager of(MinecraftServer server) {
        return IPPerServerInfo.of((MinecraftServer)server).teleportationManager;
    }

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(server -> ServerTeleportationManager.of(server).tick(server));
        Portal.SERVER_PORTAL_TICK_SIGNAL.register(portal -> {
            ServerTeleportationManager serverTeleportationManager = ServerTeleportationManager.of(portal.method_5682());
            ServerTeleportationManager.getEntitiesToTeleport(portal).forEach(entity -> serverTeleportationManager.startTeleportingRegularEntity((Portal)portal, (class_1297)entity));
        });
        DimensionAPI.SERVER_PRE_REMOVE_DIMENSION_EVENT.register(world -> ServerTeleportationManager.of(world.method_8503()).evacuatePlayersFromDimension(world));
    }

    private void tick(MinecraftServer server) {
        this.teleportingEntities.clear();
        this.manageGlobalPortalTeleportation();
    }

    public static boolean shouldEntityTeleport(Portal portal, class_1297 entity) {
        if (entity.method_37908() != portal.method_37908()) {
            return false;
        }
        if (!portal.canTeleportEntity(entity)) {
            return false;
        }
        class_243 lastEyePos = entity.method_5836(0.0f);
        class_243 nextEyePos = entity.method_5836(1.0f);
        if (entity instanceof class_1676) {
            nextEyePos = nextEyePos.method_1019(McHelper.getWorldVelocity(entity));
        }
        boolean movedThroughPortal = portal.isMovedThroughPortal(lastEyePos, nextEyePos);
        return movedThroughPortal;
    }

    public void startTeleportingRegularEntity(Portal portal, class_1297 entity) {
        if (entity instanceof class_3222) {
            return;
        }
        if (entity instanceof Portal) {
            return;
        }
        if (entity.method_5854() != null || this.doesEntityClusterContainPlayer(entity)) {
            return;
        }
        if (entity.method_31481()) {
            return;
        }
        if (!entity.method_61113(entity.method_37908(), portal.getDestinationWorld())) {
            return;
        }
        if (this.isJustTeleported(entity, 1L)) {
            return;
        }
        if (entity.field_6014 == 0.0 && entity.field_6036 == 0.0 && entity.field_5969 == 0.0) {
            LOGGER.warn("Trying to teleport a fresh new entity {}", (Object)entity);
            return;
        }
        double motion = McHelper.lastTickPosOf(entity).method_1025(entity.method_19538());
        if (motion > 20.0) {
            return;
        }
        ServerTaskList.of(portal.method_5682()).addTask(() -> {
            try {
                this.teleportRegularEntity(entity, portal);
            }
            catch (Throwable e) {
                LOGGER.error("", e);
            }
            return true;
        });
    }

    private static Stream<class_1297> getEntitiesToTeleport(Portal portal) {
        return portal.method_37908().method_8390(class_1297.class, portal.method_5829().method_1014(2.0), e -> true).stream().filter(e -> !(e instanceof Portal)).filter(entity -> ServerTeleportationManager.shouldEntityTeleport(portal, entity));
    }

    public void onPlayerTeleportedInClient(class_3222 player, class_5321<class_1937> dimensionBefore, class_243 eyePosBeforeTeleportation, UUID portalId) {
        if (player.method_35049() != null) {
            LOGGER.error("Trying to teleport a removed player {}", (Object)player);
            return;
        }
        Portal portal = this.findPortal(player.field_13995, dimensionBefore, portalId);
        if (portal == null) {
            LOGGER.error("Unable to find portal {} in {} to teleport {}", new Object[]{portalId, dimensionBefore.method_29177(), player});
            return;
        }
        this.lastTeleportGameTime.put((class_1297)player, McHelper.getServerGameTime());
        class_243 oldFeetPos = eyePosBeforeTeleportation.method_1020(McHelper.getEyeOffset((class_1297)player));
        String failReason = this.validatePlayerTeleportationAndGetReason(player, dimensionBefore, oldFeetPos, portal);
        if (failReason == null) {
            if (this.isTeleporting((class_1297)player)) {
                LOGGER.info("{} is teleporting frequently", (Object)player);
            }
            ServerTeleportationManager.notifyChasersForPlayer(player, portal);
            class_5321<class_1937> dimensionTo = portal.getDestDim();
            class_243 newEyePos = portal.transformPoint(eyePosBeforeTeleportation);
            this.recordLastPosition(player, dimensionBefore, oldFeetPos);
            this.teleportPlayer(player, dimensionTo, newEyePos);
            portal.onEntityTeleportedOnServer((class_1297)player);
            ScaleUtils.onServerEntityTeleported((class_1297)player, portal);
            if (portal.getTeleportChangesGravity()) {
                class_2350 oldGravityDir = GravityChangerInterface.invoker.getGravityDirection((class_1297)player);
                GravityChangerInterface.invoker.setBaseGravityDirectionServer((class_1297)player, portal.getTransformedGravityDirection(oldGravityDir));
            }
        } else {
            LOGGER.error("Player {} {} {} cannot teleport through portal {}\nReason: {}", new Object[]{player, player.method_37908().method_27983().method_29177(), player.method_19538(), portal, failReason});
            ServerTeleportationManager.teleportEntityGeneral((class_1297)player, player.method_19538(), (class_3218)player.method_37908());
            ScaleUtils.setBaseScale((class_1297)player, ScaleUtils.getBaseScale((class_1297)player));
            GravityChangerInterface.invoker.setBaseGravityDirectionServer((class_1297)player, GravityChangerInterface.invoker.getGravityDirection((class_1297)player));
        }
    }

    @Nullable
    private Portal findPortal(MinecraftServer server, class_5321<class_1937> dimensionBefore, UUID portalId) {
        class_3218 originalWorld = server.method_3847(dimensionBefore);
        if (originalWorld == null) {
            LOGGER.error("Missing world {} when finding portal", (Object)dimensionBefore.method_29177());
            return null;
        }
        class_1297 portalEntity = originalWorld.method_14190(portalId);
        if (portalEntity == null) {
            portalEntity = GlobalPortalStorage.get((class_3218)originalWorld).data.stream().filter(p -> p.method_5667().equals(portalId)).findFirst().orElse(null);
        }
        if (portalEntity == null) {
            return null;
        }
        if (portalEntity instanceof Portal) {
            return (Portal)portalEntity;
        }
        return null;
    }

    public void recordLastPosition(class_3222 player, class_5321<class_1937> dim, class_243 pos) {
        this.lastPosition.put(player, new WithDim<class_243>(dim, pos));
    }

    @Nullable
    private String validatePlayerTeleportationAndGetReason(class_3222 player, class_5321<class_1937> dimensionBefore, class_243 posBefore, Portal portal) {
        if (player.method_5854() != null) {
            return null;
        }
        if (((IEServerPlayNetworkHandler)player.field_13987).ip_hasAwaitingTeleport()) {
            return "has awaiting teleport";
        }
        if (!portal.canTeleportEntity((class_1297)player)) {
            return "portal cannot teleport player";
        }
        if (player.method_37908().method_27983() != dimensionBefore) {
            return "player is not in the dimensionBefore in packet";
        }
        if (player.method_19538().method_1025(posBefore) > 256.0) {
            return "player is too far from the posBefore in packet";
        }
        if (portal.getDistanceToNearestPointInPortal(posBefore) > 20.0) {
            return "posBefore is too far from portal";
        }
        return null;
    }

    public static boolean canPlayerReachPos(class_3222 player, class_5321<class_1937> dimension, class_243 pos) {
        class_243 playerPos = player.method_19538();
        if (player.method_37908().method_27983() == dimension && playerPos.method_1025(pos) < 256.0) {
            return true;
        }
        return IPMcHelper.getNearbyPortals((class_1297)player, 20.0).filter(portal -> portal.getDestDim() == dimension).filter(portal -> portal.canTeleportEntity((class_1297)player)).map(portal -> portal.transformPoint(playerPos)).anyMatch(mappedPos -> mappedPos.method_1025(pos) < 256.0);
    }

    public static boolean canPlayerReachBlockEntity(class_3222 player, class_2586 blockEntity) {
        class_1937 world = blockEntity.method_10997();
        if (world == null) {
            return false;
        }
        return ServerTeleportationManager.canPlayerReachPos(player, (class_5321<class_1937>)world.method_27983(), class_243.method_24953((class_2382)blockEntity.method_11016()));
    }

    public void teleportPlayer(class_3222 player, class_5321<class_1937> dimensionTo, class_243 newEyePos) {
        MinecraftServer server = player.field_13995;
        server.method_16044().method_15396("portal_teleport");
        class_3218 fromWorld = (class_3218)player.method_37908();
        class_3218 toWorld = server.method_3847(dimensionTo);
        if (player.method_37908().method_27983() == dimensionTo) {
            McHelper.setEyePos((class_1297)player, newEyePos, newEyePos);
            McHelper.updateBoundingBox((class_1297)player);
        } else {
            this.changePlayerDimension(player, fromWorld, toWorld, newEyePos);
        }
        McHelper.adjustVehicle((class_1297)player);
        player.field_13987.method_14372();
        PortalCollisionHandler.updateCollidingPortalAfterTeleportation((class_1297)player, newEyePos, newEyePos, 1.0f);
        server.method_16044().method_15407();
    }

    public void forceTeleportPlayer(class_3222 player, class_5321<class_1937> dimensionTo, class_243 newPos) {
        this.forceTeleportPlayer(player, dimensionTo, newPos, true);
    }

    public void forceTeleportPlayer(class_3222 player, class_5321<class_1937> dimensionTo, class_243 newPos, boolean sendPacket) {
        if (IPConfig.getConfig().serverTeleportLogging) {
            LOGGER.info("Force teleporting {} to {} {}", new Object[]{player, dimensionTo.method_29177(), newPos});
        }
        class_3218 fromWorld = (class_3218)player.method_37908();
        class_3218 toWorld = player.field_13995.method_3847(dimensionTo);
        if (toWorld == null) {
            LOGGER.error("Cannot teleport player {} to non-existing dimension {}", (Object)player, (Object)dimensionTo.method_29177());
            return;
        }
        if (player.method_37908().method_27983() == dimensionTo) {
            player.method_5814(newPos.field_1352, newPos.field_1351, newPos.field_1350);
        } else {
            this.changePlayerDimension(player, fromWorld, toWorld, newPos.method_1019(McHelper.getEyeOffset((class_1297)player)));
        }
        if (sendPacket) {
            player.field_13987.method_14363(newPos.field_1352, newPos.field_1351, newPos.field_1350, player.method_36454(), player.method_36455());
        }
        player.field_13987.method_14372();
        class_243 newEyePos = McHelper.getEyePos((class_1297)player);
        PortalCollisionHandler.updateCollidingPortalAfterTeleportation((class_1297)player, newEyePos, newEyePos, 1.0f);
        ImmPtlChunkTracking.immediatelyUpdateForPlayer(player);
    }

    private void changePlayerDimension(class_3222 player, class_3218 fromWorld, class_3218 toWorld, class_243 newEyePos) {
        this.teleportingEntities.add((class_1297)player);
        class_1297 vehicle = player.method_5854();
        if (vehicle != null) {
            ((IEServerPlayerEntity)player).ip_stopRidingWithoutTeleportRequest();
        }
        class_243 oldPos = player.method_19538();
        fromWorld.method_18770(player, class_1297.class_5529.field_27002);
        ((IEEntity)player).ip_unsetRemoved();
        McHelper.setEyePos((class_1297)player, newEyePos, newEyePos);
        McHelper.updateBoundingBox((class_1297)player);
        player.method_51468(toWorld);
        toWorld.method_18769((class_1297)player);
        if (vehicle != null) {
            class_243 offset = McHelper.getVehicleOffsetFromPassenger(vehicle, (class_1297)player);
            class_243 vehiclePos = player.method_19538().method_1019(offset);
            vehicle = this.teleportVehicleAcrossDimensions(vehicle, (class_5321<class_1937>)toWorld.method_27983(), vehiclePos.method_1019(McHelper.getEyeOffset(vehicle)));
            McHelper.setPosAndLastTickPos(vehicle, player.method_19538().method_1019(offset), McHelper.lastTickPosOf((class_1297)player).method_1019(offset));
            ((IEServerPlayerEntity)player).ip_startRidingWithoutTeleportRequest(vehicle);
            McHelper.adjustVehicle((class_1297)player);
        }
        if (IPConfig.getConfig().serverTeleportLogging) {
            LOGGER.info("{} :: ({} {} {} {})->({} {} {} {})", new Object[]{player.method_5477().method_10851(), fromWorld.method_27983().method_29177(), oldPos.method_10216(), oldPos.method_10214(), oldPos.method_10215(), toWorld.method_27983().method_29177(), (int)player.method_23317(), (int)player.method_23318(), (int)player.method_23321()});
        }
        O_O.onPlayerTravelOnServer(player, fromWorld, toWorld);
        ((IEServerPlayerEntity)player).portal_worldChanged(fromWorld, oldPos);
    }

    private void manageGlobalPortalTeleportation() {
        for (class_3218 world : MiscHelper.getServer().method_3738()) {
            for (class_1297 entity : world.method_27909()) {
                Portal collidingPortal;
                if (entity instanceof class_3222 || (collidingPortal = ((IEEntity)entity).ip_getCollidingPortal()) == null || !collidingPortal.getIsGlobal() || !ServerTeleportationManager.shouldEntityTeleport(collidingPortal, entity)) continue;
                this.startTeleportingRegularEntity(collidingPortal, entity);
            }
        }
    }

    public boolean isTeleporting(class_1297 entity) {
        return this.teleportingEntities.contains(entity);
    }

    private void teleportRegularEntity(class_1297 entity, Portal portal) {
        Long lastTeleportGameTime;
        Validate.isTrue((!(entity instanceof class_3222) ? 1 : 0) != 0);
        if (entity.method_35049() != null) {
            LOGGER.error("Trying to teleport an entity that is already removed {} {}", (Object)entity, (Object)portal);
            return;
        }
        if (entity.method_37908() != portal.method_37908()) {
            LOGGER.error("Cannot teleport {} from {} through {}", new Object[]{entity, entity.method_37908().method_27983(), portal});
            return;
        }
        if (portal.getDistanceToNearestPointInPortal(entity.method_33571()) > 5.0) {
            LOGGER.error("Entity is too far to teleport {} {}", (Object)entity, (Object)portal);
            return;
        }
        long currGameTime = McHelper.getServerGameTime();
        if (currGameTime - (lastTeleportGameTime = this.lastTeleportGameTime.getOrDefault(entity, 0L)) <= 0L) {
            return;
        }
        this.lastTeleportGameTime.put(entity, currGameTime);
        if (entity.method_5765() || this.doesEntityClusterContainPlayer(entity)) {
            return;
        }
        class_243 velocity = entity.method_18798();
        class_243 oldPos = entity.method_19538();
        List passengerList = entity.method_5685();
        class_243 newEyePos = ServerTeleportationManager.getRegularEntityTeleportedEyePos(entity, portal);
        TeleportationUtil.transformEntityVelocity(portal, entity, TeleportationUtil.PortalPointVelocity.ZERO, oldPos);
        if (portal.getDestDim() != entity.method_37908().method_27983()) {
            class_1297 newEntity = entity = this.changeEntityDimension(entity, portal.getDestDim(), newEyePos, true);
            passengerList.stream().map(e -> this.changeEntityDimension((class_1297)e, portal.getDestDim(), newEyePos, true)).collect(Collectors.toList()).forEach(e -> e.method_5873(newEntity, true));
        }
        McHelper.setEyePos(entity, newEyePos, newEyePos);
        McHelper.updateBoundingBox(entity);
        McHelper.sendToTrackers(entity, McRemoteProcedureCall.createPacketToSendToClient("qouteall.imm_ptl.core.teleportation.ClientTeleportationManager.RemoteCallables.updateEntityPos", entity.method_37908().method_27983(), entity.method_5628(), entity.method_19538()));
        portal.onEntityTeleportedOnServer(entity);
        ScaleUtils.onServerEntityTeleported(entity, portal);
        this.lastTeleportGameTime.put(entity, currGameTime);
    }

    private static class_243 getRegularEntityTeleportedEyePos(class_1297 entity, Portal portal) {
        class_243 eyePosLastTick;
        class_243 deltaMovement;
        class_243 deltaMovementDirection;
        class_243 eyePosThisTick = McHelper.getEyePos(entity);
        class_243 collidingPoint = portal.rayTrace(eyePosThisTick.method_1020((deltaMovementDirection = (deltaMovement = eyePosThisTick.method_1020(eyePosLastTick = McHelper.getLastTickEyePos(entity))).method_1029()).method_1021(5.0)), eyePosThisTick.method_1019(deltaMovementDirection));
        if (collidingPoint == null) {
            collidingPoint = eyePosLastTick;
        }
        class_243 result = portal.transformPoint(collidingPoint).method_1019(deltaMovementDirection.method_1021(0.05));
        return result;
    }

    public class_1297 changeEntityDimension(class_1297 entity, class_5321<class_1937> toDimension, class_243 newEyePos, boolean recreateEntity) {
        if (entity.method_35049() != null) {
            LOGGER.error("Trying to teleport a removed entity {}", (Object)entity, (Object)new Throwable());
            return entity;
        }
        MinecraftServer server = entity.method_5682();
        Validate.notNull((Object)server, (String)"server is null", (Object[])new Object[0]);
        class_3218 fromWorld = (class_3218)entity.method_37908();
        class_3218 toWorld = server.method_3847(toDimension);
        if (toWorld == null) {
            LOGGER.error("Invalid dest dimension {} to teleport entity {} to", (Object)toDimension.method_29177(), (Object)entity);
            return entity;
        }
        entity.method_18375();
        if (recreateEntity) {
            class_1297 oldEntity = entity;
            class_1297 newEntity = entity.method_5864().method_5883((class_1937)toWorld);
            if (newEntity == null) {
                return oldEntity;
            }
            newEntity.method_5878(oldEntity);
            newEntity.method_5838(oldEntity.method_5628());
            McHelper.setEyePos(newEntity, newEyePos, newEyePos);
            McHelper.updateBoundingBox(newEntity);
            newEntity.method_5847(oldEntity.method_5791());
            oldEntity.method_5650(class_1297.class_5529.field_27002);
            toWorld.method_18769(newEntity);
            return newEntity;
        }
        entity.method_5650(class_1297.class_5529.field_27002);
        ((IEEntity)entity).ip_unsetRemoved();
        McHelper.setEyePos(entity, newEyePos, newEyePos);
        McHelper.updateBoundingBox(entity);
        ((IEEntity)entity).ip_setWorld((class_1937)toWorld);
        toWorld.method_18769(entity);
        Validate.isTrue((!entity.method_31481() ? 1 : 0) != 0);
        return entity;
    }

    public class_1297 teleportVehicleAcrossDimensions(class_1297 entity, class_5321<class_1937> toDimension, class_243 newEyePos) {
        this.teleportingEntities.add(entity);
        class_3218 fromWorld = (class_3218)entity.method_37908();
        class_3218 toWorld = MiscHelper.getServer().method_3847(toDimension);
        class_1297 oldEntity = entity;
        class_1297 newEntity = entity.method_5864().method_5883((class_1937)toWorld);
        Validate.isTrue((newEntity != null ? 1 : 0) != 0);
        newEntity.method_5878(oldEntity);
        newEntity.method_5838(oldEntity.method_5628());
        McHelper.setEyePos(newEntity, newEyePos, newEyePos);
        McHelper.updateBoundingBox(newEntity);
        newEntity.method_5847(oldEntity.method_5791());
        oldEntity.method_5650(class_1297.class_5529.field_27002);
        ((IEEntity)oldEntity).ip_unsetRemoved();
        toWorld.method_18769(newEntity);
        return newEntity;
    }

    private boolean doesEntityClusterContainPlayer(class_1297 entity) {
        if (entity instanceof class_1657) {
            return true;
        }
        List passengerList = entity.method_5685();
        if (passengerList.isEmpty()) {
            return false;
        }
        return passengerList.stream().anyMatch(this::doesEntityClusterContainPlayer);
    }

    public boolean isJustTeleported(class_1297 entity, long valveTickTime) {
        Long lastTeleportGameTime;
        long currGameTime = McHelper.getServerGameTime();
        return currGameTime - (lastTeleportGameTime = this.lastTeleportGameTime.getOrDefault(entity, -100000L)) < valveTickTime;
    }

    public static class_1297 teleportEntityGeneral(class_1297 entity, class_243 targetPos, class_3218 targetWorld) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            ServerTeleportationManager.of(serverPlayer.field_13995).forceTeleportPlayer(serverPlayer, (class_5321<class_1937>)targetWorld.method_27983(), targetPos);
            return entity;
        }
        return ServerTeleportationManager.teleportRegularEntityTo(entity, (class_5321<class_1937>)targetWorld.method_27983(), targetPos);
    }

    public static <E extends class_1297> E teleportRegularEntityTo(E entity, class_5321<class_1937> targetDim, class_243 targetPos) {
        if (entity.method_37908().method_27983() == targetDim) {
            entity.method_5808(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, entity.method_36454(), entity.method_36455());
            entity.method_5847(entity.method_36454());
            return entity;
        }
        return (E)ServerTeleportationManager.of(entity.method_5682()).changeEntityDimension(entity, targetDim, targetPos.method_1019(McHelper.getEyeOffset(entity)), true);
    }

    private static void notifyChasersForPlayer(class_3222 player, Portal portal) {
        List<class_1308> chasers = McHelper.findEntitiesRough(class_1308.class, player.method_37908(), player.method_19538(), 1, e -> e.method_5968() == player);
        for (class_1308 chaser : chasers) {
            chaser.method_5980(null);
            ServerTeleportationManager.notifyChaser(player, portal, chaser);
        }
    }

    private static void notifyChaser(class_3222 player, Portal portal, class_1308 chaser) {
        class_243 targetPos = player.method_19538().method_1019(portal.getNormal().method_1021(-0.1));
        UUID chaserId = chaser.method_5667();
        class_3218 destWorld = (class_3218)portal.getDestinationWorld();
        ServerTaskList.of(player.field_13995).addTask(MyTaskList.withRetryNumberLimit(140, () -> {
            if (chaser.method_31481()) {
                class_1297 newChaser = destWorld.method_14190(chaserId);
                if (newChaser instanceof class_1308) {
                    ((class_1308)newChaser).method_5980((class_1309)player);
                    return true;
                }
                return false;
            }
            if (chaser.method_19538().method_1022(targetPos) < 2.0) {
                chaser.method_5962().method_6239(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350, 1.0);
            } else {
                @Nullable class_11 path = chaser.method_5942().method_6348(class_2338.method_49638((class_2374)targetPos), 0);
                chaser.method_5942().method_6334(path, 1.0);
            }
            return false;
        }, () -> {}));
    }

    private void evacuatePlayersFromDimension(class_3218 world) {
        ArrayList players = new ArrayList(MiscHelper.getServer().method_3760().method_14571());
        for (class_3222 player : players) {
            if (player.method_37908().method_27983() != world.method_27983()) continue;
            class_3218 overWorld = McHelper.getOverWorldOnServer();
            class_2338 spawnPos = overWorld.method_43126();
            this.forceTeleportPlayer(player, (class_5321<class_1937>)class_1937.field_25179, class_243.method_24953((class_2382)spawnPos));
            player.method_43496((class_2561)class_2561.method_43470((String)"Teleported to spawn pos because dimension %s had been removed".formatted(world.method_27983().method_29177())));
        }
    }
}

